#ifndef WORLD_HPP
#define WORLD_HPP

#include "stdafx.h"
#include "vector1.h"
#include <time.h> //For clock_t, clock(), CLOCKS_PER_SEC

//Outcodes for Box2::Outcode
#define BOX2_INSIDE 0
#define BOX2_LEFT 1
#define BOX2_UP 2
#define BOX2_RIGHT 4
#define BOX2_DOWN 8
#define BOX2_UP_LEFT (BOX2_UP|BOX2_LEFT)
#define BOX2_UP_RIGHT (BOX2_UP|BOX2_RIGHT)
#define BOX2_DOWN_LEFT (BOX2_DOWN|BOX2_LEFT)
#define BOX2_DOWN_RIGHT (BOX2_DOWN|BOX2_RIGHT)


class Box2
{
private:
	Real _lox, _loy, _hix, _hiy;
   void _Arrange(); //helper function
public:
	//constructors
	Box2():_lox(0),_hiy(0),_hix(0),_loy(0){}
	Box2(Real px, Real py, Real qx, Real qy);
	//accessors
	Real lox()const {return _lox;}
	Real hix()const {return _hix;}
	Real hiy()const {return _hiy;}
	Real loy()const {return _loy;}
	Real XRadius()const {return (_hix - _lox)/2.0;}
	Real YRadius()const {return (_hiy - _loy)/2.0;}
	//mutators
	void MatchAspect(int cx, int cy);
	//methods
	Vector2 Randomlocation() const;
	BOOL Inside(const Vector2 &testpos)const;
	int Outcode(const Vector2 &testpos)const;
	Real Distance(const Vector2 &testpos)const;
	int Wrap(Vector2 &position)const; /* If you move off one edge,
		then come back in the same amount from the other side */
	int Clamp(Vector2 &position)const; /*Make sure position is inside*/
};

/* The cTimeAdjuster measures the _rMeasureCycles_dt that it takes for
_nMeasureCycles updates to execute.  _rCycle_dt is the quotient.  The
adjustDt(*world) method sets the world->_dt = world->_runspeed * rCycle_dt */
class cTimeAdjuster
{
private:
	int _nUpdateCount;
	int _nTargetCount;
	Real _rCycle_dt;
	clock_t _start; //a clock_t type is really just a long
	friend class World;
public:
	cTimeAdjuster(int nCyclesToCount = 10);
	void reset();
	BOOL update();
};

class World
{
private:
	Box2 _box;
	Real _dt;
	Real _runspeed;
	BOOL _wrapflag;
	Vector2 _cursorvector;
	cTimeAdjuster _cTimeAdjuster;
public:
	//--------------Constructor-----------------
	World(Box2 &box = Box2(-4.0, -3.0, 4.0, 3.0), Real dt = 0.03,
		 Real runspeed = 0.2, BOOL wrapflag = FALSE); // Default box has same ratio as pixel screen.
	//--------------Accessors-----------------
	Real dt()const{return _dt;}
	Box2 box()const{return _box;}
	BOOL wrapflag()const{return _wrapflag;}
	Vector2 cursorvector()const{return _cursorvector;}
	Real runspeed(){return _runspeed;}
	//--------------Mutators-----------------
	void Set_dt(Real dt){_dt = _runspeed * dt;}
	void Set_wrapflag(BOOL wrapflag){_wrapflag = wrapflag;}
	void Set_box(Box2 &box);
	void Set_cursorvector(Vector2 &cursorvector){_cursorvector = cursorvector;}
	void setRunspeed(Real runspeed);
	//--------------Methods-----------------
	int Wrap(Vector2 &position)const;
	int Clamp(Vector2 &position)const;
	int ClampBounce(Vector2 &position, Vector2 &direction)const;
	//clamp, and if position is outside, then reflect direction appropriately
	void resetTimeAdjuster();
	void updateTimeAdjuster();
};


	
#endif //WORLD_HPP
